﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Runtime.InteropServices
Imports System.IO.Ports
Imports System.Text.RegularExpressions
Imports VB_ZPL.Printer
Public Class ZPL_Demo
    Private printer As DemoPrinter = New DemoPrinter()
    Dim iResult As Integer = 0
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        iResult = printer.DemoPrinterCreator("CP30")
        If Constants.E_SUCCESS = iResult Then
            iResult = printer.DemoPortOpen("USB")
            If Constants.E_SUCCESS = iResult Then
                '开始
                iResult = printer.DemoStartFormat()

                '设置打印浓度
                iResult = printer.DemoSetPrintDarkness(20)

                '设置是否翻转打印
                iResult = printer.DemoSetPrintOrientation(0)

                '打印图片
                iResult = printer.DemoPrintImage(100, 100, "D:\\1.bmp")

                '打印Pdf417
                iResult = printer.DemoPdf417(100, 250, 0, 2, 20, 2, 5, 5, "N", "0010101101")

                '打印BarCode39条码
                iResult = printer.DemoBarCode39(100, 400, 0, 3, 50, "Y", "Y", "Y", "0123456")

                '打印CodeEan8条码
                iResult = printer.DemoCodeEan8(100, 500, 0, 3, 60, "Y", "Y", "90381010")

                '打印UPC-A
                iResult = printer.DemoUpcaBarcode(100, 600, 0, 3, 50, "Y", "Y", "N", "47631664454")

                '打印UPC扩展条码
                iResult = printer.DemoUpcExtensions(100, 700, 0, 3, 50, "Y", "Y", "01234")

                '打印二维码
                iResult = printer.DemoQRCode(100, 800, 0, 1, 3, "M", 7, "1000000001")

                '打印
                iResult = printer.DemoSetChangeFontEncoding(14)
                iResult = printer.DemoText(100, 900, 16, 0, 40, 40, "你好")
                iResult = printer.DemoText(300, 900, 16, 0, 40, 40, "hello")
                iResult = printer.DemoText(500, 900, 16, 0, 40, 40, "こんにちは")

                '绘制图形圆圈
                iResult = printer.DemoGraphicCircle(100, 1000, 150, 5)

                '打印椭圆
                iResult = printer.DemoGraphicEllipse(300, 1000, 150, 100, 10)

                '打印对角线
                iResult = printer.DemoGraphicDiagonalLine(500, 1000, &H52, 50, 50, 20)

                '绘制图形框
                iResult = printer.DemoGraphicBox(100, 1200, 100, 100, 60, 3)

                '打印符号
                iResult = printer.DemoGraphicSymbol(300, 1200, 0, 200, 200, "A")

                '结束
                iResult = printer.DemoEndFormat()

                '关闭端口
                iResult = printer.DemoPortClose()

                '销毁
                iResult = printer.DemoPrinterDestroy()
            Else
                MessageBox.Show("Usb Device not found.")
                Close()
            End If
        Else
            MessageBox.Show("Printer Device not found.")
            Close()
        End If

    End Sub
End Class
